<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateHorairesTable extends Migration {

	public function up()
	{
		Schema::create('horaires', function(Blueprint $table) {
			$table->increments('id');
			$table->time('horaire_debut');
			$table->time('horaire_fin');
			$table->enum('jours', array('lundi', 'mardi', 'mercredi', 'jeudi', 'vendredi', 'samedi', 'dimanche'));
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('horaires');
	}
}