<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePaiementsTable extends Migration {

	public function up()
	{
		Schema::create('paiements', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('achat_id')->unsigned()->index();
			$table->enum('paiement_type', array('espece', 'cheque', 'virement', 'online', 'cb'));
			$table->date('date');
			$table->tinyInteger('banque');
			$table->float('montant', 8,2);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('paiements');
	}
}