<?php

namespace Models\Ais\Facility;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Position extends Eloquent {

	protected $table = 'ais_facility_position';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function atcSessions()
	{
		return $this->hasMany('Models\Stats\Atc', 'position_id', 'position_id');
	}

	public function facility()
	{
		return $this->belongsTo('Models\Ais\Facility', 'facility_id', 'facility_id');
	}

}