<?php

namespace Models\Ais\Airport;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Runway extends Eloquent {

	protected $table = 'ais_airport_runway';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function airport()
	{
		return $this->belongsTo('Models\Ais\Airport', 'airport_id', 'airport_id');
	}

	public function recipricol()
	{
		return $this->hasOne('Models\Ais\Airport\Runway', 'runway_id', 'recipricol_id');
	}

}