<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStatsFlightRouteTable extends Migration {

	public function up()
	{
		Schema::create('stats_flight_route', function(Blueprint $table) {
			$table->increments('flight_route_id');
			$table->bigInteger('flight_id')->unsigned();
			$table->string('departure', 4);
			$table->text('route_raw');
			$table->text('route_clean');
			$table->string('route_md5', 32);
			$table->string('arrival', 4);
			$table->string('alternative', 4)->nullable();
			$table->smallInteger('flight_level')->unsigned();
			$table->smallInteger('speed')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('stats_flight_route');
	}
}