<?php

namespace Models\Stats;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Flight extends Eloquent {

	protected $table = 'stats_flight';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function routes()
	{
		return $this->hasMany('Models\Stats\Flight\Route', 'flight_id', 'flight_id');
	}

	public function posreps()
	{
		return $this->hasMany('Models\Stats\Flight\Posrep', 'flight_id', 'flight_id');
	}

	public function account()
	{
		return $this->belongsTo('Models\Mship\Account', 'account_id', 'account_id');
	}

}