<?php

namespace Models\Stats\Flight;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Route extends Eloquent {

	protected $table = 'stats_flight_route';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function flight()
	{
		return $this->belongsTo('Models\Stats\Flight', 'flight_id', 'flight_id');
	}

	public function waypoints()
	{
		return $this->hasMany('Models\Stats\Flight\Route\Waypoint', 'flight_route_id', 'flight_route_id');
	}

}