<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateHostTable extends Migration {

	public function up()
	{
		Schema::create('Host', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 64);
			$table->string('description', 128);
			$table->string('tags', 128);
			$table->string('domain', 128);
			$table->boolean('isVerified')->default(0);
			$table->string('verificationToken', 128);
		});
	}

	public function down()
	{
		Schema::drop('Host');
	}
}