<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserTable extends Migration {

	public function up()
	{
		Schema::create('User', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 64);
			$table->string('email', 191);
			$table->string('password', 191);
			$table->tinyInteger('active');
			$table->string('confirmation_token', 100);
			$table->tinyInteger('confirmed');
			$table->string('remember_token', 100);
			$table->string('locale', 191);
			$table->string('timezone', 191);
			$table->string('slug', 191);
			$table->timestamp('last_access_at');
			$table->timestamp('created_at');
			$table->timestamp('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('User');
	}
}