<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Player extends Eloquent {

	protected $table = 'players';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('address', 'post_code', 'sru_number', 'tel_no', 'mob_no', 'kin', 'issues');

	public function user()
	{
		return $this->belongsTo('\User');
	}

}