<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateArticlesTable extends Migration {

	public function up()
	{
		Schema::create('articles', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('title', 255);
			$table->longText('content');
			$table->string('image', 255)->default('0');
			$table->integer('category_id')->unsigned();
			$table->integer('status');
		});
	}

	public function down()
	{
		Schema::drop('articles');
	}
}