<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Donation extends Model 
{

    protected $table = 'donations';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function Clients()
    {
        return $this->belongsTo('Clients', 'client_id');
    }

    public function Notifications()
    {
        return $this->hasMany('Notifications');
    }

}