<?php

namespace APP;

use Illuminate\Database\Eloquent\Model;

class ForumCategory extends Model 
{

    protected $table = 'forum_categories';
    public $timestamps = true;

    public function group()
    {
        return $this->belongsTo('ForumGroup');
    }

    public function threads()
    {
        return $this->hasMany('ForumThread', 'category_id');
    }

    public function comments()
    {
        return $this->hasMany('ForumComment', 'category_id');
    }

}