<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQrcodesTable extends Migration {

	public function up()
	{
		Schema::create('qrcodes', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('qrcode');
			$table->string('token')->nullable();
			$table->string('otp', 15)->nullable();
			$table->datetime('date_otp')->nullable();
			$table->bigInteger('agent_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('qrcodes');
	}
}