<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Question extends Eloquent {

	protected $table = 'question';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('title', 'hint', 'explanation', 'referencematerial', 'imagepath', 'published');

	public function Answer()
	{
		return $this->hasMany('Answer');
	}

	public function Quiz()
	{
		return $this->belongsToMany('Quiz')->withPivot('question_quiz');
	}

	public function Category()
	{
		return $this->hasMany('Category')->withPivot('category_question');
	}

}