<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('Users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('email');
			$table->string('phone')->unique()->nullable();
			$table->string('asterisk_ip')->nullable();
			$table->string('ex_number')->unique()->nullable();
			$table->string('ex_pass')->nullable();
			$table->enum('ex_type', array('sip', 'web'));
			$table->string('menu_id')->nullable();
			$table->string('password');
			$table->enum('gender', array('male', 'female'));
			$table->enum('status', array('active', 'inactive'));
			$table->integer('tenant_id')->unsigned()->nullable();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('Users');
	}
}