<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTicketsTable extends Migration {

	public function up()
	{
		Schema::create('tickets', function(Blueprint $table) {
			$table->increments('id');
			$table->string('subject');
			$table->string('type');
			$table->integer('agent_id')->unsigned();
			$table->integer('contact_id')->unsigned()->nullable();
			$table->enum('status', array('canceled', 'pending', 'in_progress', 'resolved', 'completed', 'dispached'));
			$table->text('desc');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('tickets');
	}
}