<?php

namespace User;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'Users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function Tenant()
	{
		return $this->hasOne('Tenant');
	}

	public function role()
	{
		return $this->hasOne('User');
	}

}