<?php

namespace User;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'Users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function Tenant()
    {
        return $this->hasOne('Tenant');
    }

    public function role()
    {
        return $this->hasOne('User');
    }

}