<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('contact_id')->unsigned()->nullable();
			$table->double('total');
			$table->enum('status', array('onhold', 'pending', 'in_progress', 'deliveried', 'completed'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}