<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function profile()
    {
        return $this->hasOne('Profile', 'user_id');
    }

    public function feeds()
    {
        return $this->hasMany('Feed');
    }

    public function feed_reactions()
    {
        return $this->hasMany('FeedReaction');
    }

    public function feed_comments()
    {
        return $this->hasMany('FeedComment');
    }

    public function chilly()
    {
        return $this->hasOne('Chilly');
    }

}