<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNotifyCustomersTable extends Migration {

	public function up()
	{
		Schema::create('notify_customers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('to_customer_id')->unsigned();
			$table->bigInteger('from_user_id')->unsigned();
			$table->string('message', 500);
			$table->boolean('is_seen');
		});
	}

	public function down()
	{
		Schema::drop('notify_customers');
	}
}