<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNotifyUsersTable extends Migration {

	public function up()
	{
		Schema::create('notify_users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('message', 500);
			$table->bigInteger('from_user_id')->unsigned();
			$table->bigInteger('to_user_id')->unsigned();
			$table->boolean('is_seen');
		});
	}

	public function down()
	{
		Schema::drop('notify_users');
	}
}