<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ArchivedServiceBranch extends Model 
{

    protected $table = 'archived_service_branch';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('branch_id', 'service_id');

    public function branch()
    {
        return $this->belongsTo('Branch', 'branch_id');
    }

    public function service()
    {
        return $this->belongsTo('ArchivedService', 'service_id');
    }

}