<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Page extends Model 
{

    protected $table = 'page';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name_en', 'name_ar', 'description_en', 'description_ar', 'center_id');

    public function center()
    {
        return $this->belongsTo('Center', 'center_id');
    }

}