<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Service extends Model 
{

    protected $table = 'service';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name_en', 'name_ar', 'description_en', 'description_ar', 'price', 'category_id', 'booking', 'require_address', 'require_reason');

    public function category()
    {
        return $this->belongsTo('Category', 'category_id');
    }

    public function branches()
    {
        return $this->belongsToMany('Branch', 'service_branch', 'service_id', 'branch_id');
    }

    public function locations()
    {
        return $this->belongsToMany('Location', 'service_location', 'service_id', 'location_id');
    }

}