<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ArchivedCategory extends Eloquent {

	protected $table = 'archived_category';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name_en', 'name_ar', 'description_en', 'description_ar');

	public function branches()
	{
		return $this->belongsToMany('Branch', 'archived_category_branch', 'category_id', 'branch_id');
	}

}