<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ArchivedService extends Eloquent {

	protected $table = 'archived_service';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name_en', 'name_ar', 'description_en', 'description_ar', 'category_id');

	public function category()
	{
		return $this->belongsTo('ArchivedCategory', 'category_id');
	}

	public function branches()
	{
		return $this->belongsToMany('Branch', 'archived_service_branch', 'service_id', 'brach_id');
	}

}