<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ArchivedServiceBranch extends Eloquent {

	protected $table = 'archived_service_branch';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('branch_id', 'service_id');

	public function branch()
	{
		return $this->belongsTo('Branch', 'branch_id');
	}

	public function service()
	{
		return $this->belongsTo('ArchivedService', 'service_id');
	}

}