<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Category extends Eloquent {

	protected $table = 'category';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name_en', 'name_ar', 'description_en', 'description_ar');

	public function services()
	{
		return $this->hasMany('Service', 'category_id');
	}

	public function branches()
	{
		return $this->belongsToMany('Branch', 'category_branch', 'category_id', 'branch_id');
	}

}