<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class CategoryBranch extends Eloquent {

	protected $table = 'category_branch';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('branch_id', 'category_id');

	public function branch()
	{
		return $this->belongsTo('Branch', 'branch_id');
	}

	public function category()
	{
		return $this->belongsTo('Category', 'category');
	}

}