<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class City extends Eloquent {

	protected $table = 'city';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('city_id', 'state_id', 'city_name');

	public function state()
	{
		return $this->belongsTo('State', 'state_id');
	}

}