<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Order extends Eloquent {

	protected $table = 'order';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('service_id', 'branch_id', 'location_id', 'member_no', 'status', 'total', 'price', 'tax', 'note', 'client_id', 'user_id', 'address_id', 'reason_id');

	public function service()
	{
		return $this->belongsTo('Service', 'service_id');
	}

	public function client()
	{
		return $this->belongsTo('User', 'client_id');
	}

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function clients()
	{
		return $this->hasMany('OrderClient', 'order_id');
	}

	public function branch()
	{
		return $this->belongsTo('Branch', 'branch_id');
	}

	public function location()
	{
		return $this->belongsTo('Location', 'location_id');
	}

	public function address()
	{
		return $this->belongsTo('Address', 'address_id');
	}

	public function reason()
	{
		return $this->belongsTo('Reason', 'reason_id');
	}

}