<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'user';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function clients()
	{
		return $this->hasMany('ClientOld', 'user_id');
	}

	public function address()
	{
		return $this->hasMany('Address', 'user_id');
	}

}