<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Center extends Eloquent {

	protected $table = 'center';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name_en', 'name_ar', 'mobile', 'branch_id');

	public function branch()
	{
		return $this->belongsTo('Branch', 'branch_id');
	}

	public function pages()
	{
		return $this->hasMany('Page', 'center_id');
	}

}