<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ClientOld extends Eloquent {

	protected $table = 'client_old';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'last_name', 'mobile', 'email', 'iq', 'nationality_id', 'gender', 'passport', 'password', 'user_id');

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function nationality()
	{
		return $this->belongsTo('Country', 'nationality_id');
	}

}