<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Doctor extends Eloquent {

	protected $table = 'doctor';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name_en', 'name_ar', 'gender', 'birthdate', 'nationality_id', 'specialty_id', 'degree_id', 'certifications', 'experiences', 'positions', 'years', 'certifications_ar', 'experiences_ar', 'positions_ar');

	public function branches()
	{
		return $this->belongsToMany('Branch', 'doctor_branch', 'doctor_id', 'branch_id');
	}

	public function nationality()
	{
		return $this->belongsTo('Nationality', 'nationality_id');
	}

	public function specialty()
	{
		return $this->belongsTo('Specialty', 'specialty_id');
	}

	public function degree()
	{
		return $this->belongsTo('Degree', 'degree_id');
	}

}