<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class OrderClient extends Eloquent {

	protected $table = 'order_client';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('order_id', 'service_id', 'client_id', 'tax', 'total', 'note');

	public function order()
	{
		return $this->belongsTo('Order', 'order_id');
	}

	public function service()
	{
		return $this->belongsTo('Service', 'service_id');
	}

	public function client()
	{
		return $this->belongsTo('Client', 'client_id');
	}

}