<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Page extends Eloquent {

	protected $table = 'page';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name_en', 'name_ar', 'description_en', 'description_ar', 'center_id');

	public function center()
	{
		return $this->belongsTo('Center', 'center_id');
	}

}