<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ServiceBranch extends Eloquent {

	protected $table = 'service_branch';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('branch_id', 'service_id');

	public function branch()
	{
		return $this->belongsTo('Branch', 'branch_id');
	}

	public function service()
	{
		return $this->belongsTo('Service', 'service_id');
	}

}