<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ServiceLocation extends Eloquent {

	protected $table = 'service_location';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('location_id', 'service_id');

	public function service()
	{
		return $this->belongsTo('Service', 'service_id');
	}

	public function location()
	{
		return $this->belongsTo('Location', 'location_id');
	}

}