<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class State extends Eloquent {

	protected $table = 'state';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('state_name', 'state_id', 'country_id');

	public function country()
	{
		return $this->belongsTo('Country', 'country_d');
	}

}