<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Category extends Model 
{

    protected $table = 'category';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name_en', 'name_ar', 'description_en', 'description_ar');

    public function services()
    {
        return $this->hasMany('Service', 'category_id');
    }

    public function branches()
    {
        return $this->belongsToMany('Branch', 'category_branch', 'category_id', 'branch_id');
    }

}