<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Client extends Model 
{

    protected $table = 'client';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('patient_name', 'middle_name', 'middle_name2', 'last_name', 'salutation', 'patient_gender', 'dateofbirth', 'patient_phone', 'patient_category_id', 'patieatient_state', 'patient_city', 'patient_address', 'country', 'nationality_id', 'government_identifier', 'user_id', 'identifier_id', 'custom_field5', 'custom_list7_value', 'custom_list5_value', 'patient_group', 'agein', 'preferred_language', 'patient_area', 'file_number');

    public function salutation()
    {
        return $this->belongsTo('Salutation', 'salutation');
    }

    public function category()
    {
        return $this->belongsTo('Category', 'patient_category_id');
    }

    public function state()
    {
        return $this->belongsTo('State', 'patieatient_state');
    }

    public function city()
    {
        return $this->belongsTo('City', 'patient_city');
    }

    public function country()
    {
        return $this->belongsTo('Country', 'country');
    }

    public function nationality()
    {
        return $this->belongsTo('Country', 'nationality_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

}