<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class DoctorBranch extends Model 
{

    protected $table = 'doctor_branch';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('doctor_id', 'branch_id');

    public function doctor()
    {
        return $this->belongsTo('Doctor', 'doctor_id');
    }

    public function branch()
    {
        return $this->belongsTo('Branch', 'branch_id');
    }

}