<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderClientTable extends Migration {

	public function up()
	{
		Schema::create('order_client', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('order_id')->nullable();
			$table->integer('service_id')->nullable();
			$table->integer('client_id')->nullable();
			$table->double('tax')->nullable();
			$table->double('total')->nullable();
			$table->text('note')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('order_client');
	}
}