<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderTable extends Migration {

	public function up()
	{
		Schema::create('order', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('service_id')->nullable();
			$table->integer('branch_id')->nullable();
			$table->integer('location_id')->nullable();
			$table->integer('member_no')->nullable();
			$table->enum('status', array('awaiting', 'completed', 'registered'))->nullable();
			$table->double('total')->nullable();
			$table->double('price')->nullable();
			$table->double('tax')->nullable();
			$table->text('note')->nullable();
			$table->integer('client_id')->nullable();
			$table->integer('user_id')->nullable();
			$table->integer('address_id')->nullable();
			$table->integer('reason_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('order');
	}
}