<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('rota', function(Blueprint $table) {
			$table->foreign('transacao_id')->references('id')->on('transacao')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('permissao', function(Blueprint $table) {
			$table->foreign('id_grupo')->references('id')->on('grupo_usuario')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('permissao', function(Blueprint $table) {
			$table->foreign('id_rota')->references('id')->on('rota')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('rota', function(Blueprint $table) {
			$table->dropForeign('rota_transacao_id_foreign');
		});
		Schema::table('permissao', function(Blueprint $table) {
			$table->dropForeign('permissao_id_grupo_foreign');
		});
		Schema::table('permissao', function(Blueprint $table) {
			$table->dropForeign('permissao_id_rota_foreign');
		});
	}
}