<?php

namespace App\ERP;

class ArticuloReal extends Eloquent {

	protected $table = 'articulos_reales';
	public $timestamps = true;

	public function articulo()
	{
		return $this->belongsTo('Articulo', 'articulo_id');
	}

	public function almacen()
	{
		return $this->belongsTo('Almacen', 'almacen_id');
	}

	public function padre()
	{
		return $this->belongsTo('ArticuloReal', 'padre_id');
	}

	public function proveedor()
	{
		return $this->belongsTo('Proveedor', 'proveedor_id');
	}

	public function estados()
	{
		return $this->hasMany('Estado', 'articulo_real_id');
	}

}