<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStiffenersTable extends Migration {

	public function up()
	{
		Schema::create('stiffeners', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->json('dimensions');
			$table->string('material_type', 255);
			$table->string('stiffener_type', 255);
			$table->integer('panel_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('stiffeners');
	}
}